function [Rt, veclRt]=Pattoneq(theta,data)
if nargout==1
    Rt=[];
end
T = size(data,1);
x = data(:,1);
y = data(:,2);
sampleCorr=corr(data);
kappa = -999.99*ones(T,1);
kappa(1) = sampleCorr(1,2);
for jj = 2:T
    if jj<=5
        psi = theta(1) + theta(2)*mean(x(1:jj-1).*y(1:jj-1)) + theta(3)*kappa(jj-1);
    else
        psi = theta(1) + theta(2)*mean(x(jj-5:jj-1).*y(jj-5:jj-1)) + theta(3)*kappa(jj-1);
    end
   kappa(jj) =(1-exp(-psi))/(1+exp(-psi));		% a modified logistic transformation
end
veclRt = kappa;  % time-path of conditional copula parameter
Rt=zeros(2,2,T);
for i=1:T;
    Rt(:,:,i)=[1 veclRt(i);veclRt(i) 1];
end
